<%@ page language="java" import="java.util.*" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%
	String path = request.getContextPath();
	String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort()
			+ path + "/";
%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<base href="<%=basePath%>" />
<link rel="stylesheet" type="text/css" href="<%= request.getContextPath()%>/resources/mta/css/examInfo.css" />
<script src="<%= request.getContextPath()%>/resources/js/jquery-easyui-1.4/jquery.min.js" type="text/javascript"></script>
<script src="<%= request.getContextPath()%>/resources/js/ajax-pushlet-client.js" type="text/javascript"></script>
<script type="text/javascript">
	var loginUserid='${userId}';
	var baseUrl='<%= request.getContextPath()%>';
	var uuid = '${dataMap.uuid}';
	var language="<%=session.getAttribute("language")%>"; 
	if (language.indexOf('en') > -1) {
		document.write("<script src='" + baseUrl + "/resources/js/mta_en/F020ExamInstrution.js'><\/script>");
	} else {
		// 默认中文
		document.write("<script src='" + baseUrl + "/resources/js/mta/F020ExamInstrution.js'><\/script>");
	}
</script>
</head>
<body>
	<div id="header">
		<c:import url="header.jsp"></c:import>
	</div>
	<input id="message" type="hidden" value="${message}"/>
	<div id="main" class="w">
			<div class="info">
				<div class="img_box l">
					<c:choose>
						<c:when test="${dataMap.pic!='' && dataMap.pic != null}">
							<img src="${dataMap.pic}" width="488" height="279" alt="${dataMap.examName}" />
						</c:when>
						<c:otherwise>
							<img src="<%= request.getContextPath()%>/resources/logo/kecheng.png" width="488" height="279" alt="${dataMap.examName}" />
						</c:otherwise>
					</c:choose>
				</div>
				<div class="info_box r">
					<!-- 考试名称： -->
					<p class="title"><spring:message code="label.font.examname"/>${dataMap.examName}</p>
					<ul id="info">
						<input type='hidden' value='${dataMap.tmSec}'/>
						<!-- 考试开始时间: -->
						<li class="l"><spring:message code="label.font.examstarttime"/>${dataMap.ksBeginTm}</li>
						<!-- 考试结束时间: -->
						<li class="l"><spring:message code="label.font.examendtime"/>${dataMap.ksEndTm}</li>
						<!-- 总分： -->
						<li class="l"><spring:message code="label.font.shijuanScore"/>${dataMap.shijuanScore}</li>
						<!-- 及格分： -->
						<li class="l"><spring:message code="label.font.okrate"/>${dataMap.okrate}</li>
						<!-- 学分： -->
						<li class="l"><spring:message code="label.font.credit"/>${dataMap.credit}</li>
						<!-- 倒计时： -->
						<li class="l time" id="time"><spring:message code="label.font.time"/></li>
					</ul>
					<!-- 立即考试 -->
					<span class="start " onclick="userExam();"><spring:message code="label.button.startexam"/></span>
				</div>
			</div>
			<div class="main_center">
				<ul class="main_nav">
					<!-- 考试须知 -->
					<li class="selected l"><spring:message code="label.font.examnote"/></li>
				</ul>
				<div class="catalog">
					${dataMap.des}
				</div>
			</div>
		</div>

				
	<div id="footer">
		<c:import url="footer.jsp"></c:import>
	</div>
</body>
<script type="text/javascript">
	if($("#message").val() != ''){
		alert($("#message").val());
	}
</script>
</html>